/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.sql.format;

import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.sql.format.BlancoSqlToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Stack;

public class BlancoSqlFormatter {
    BlancoSqlParser parser = new BlancoSqlParser();
    BlancoSqlRule rule = null;

    public BlancoSqlFormatter(BlancoSqlRule rule) {
        this.rule = rule;
    }

    public String format(String sql) throws BlancoSqlFormatterException {
        try {
            boolean isSqlEndsWithNewLine = false;
            if (sql.endsWith("\n")) {
                isSqlEndsWithNewLine = true;
            }
            List list = this.parser.parse(sql);
            list = this.format(list);
            String after = "";
            for (int i = 0; i < list.size(); ++i) {
                BlancoSqlToken t = (BlancoSqlToken)list.get(i);
                after = after + t.s;
            }
            if (isSqlEndsWithNewLine) {
                after = after + "\n";
            }
            return after;
        }
        catch (Exception ex) {
            BlancoSqlFormatterException sqlException = new BlancoSqlFormatterException(ex.toString());
            sqlException.initCause(ex);
            throw sqlException;
        }
    }

    private List format(List list) {
        int i;
        int i2;
        BlancoSqlToken t = (BlancoSqlToken)list.get(0);
        if (t.type == 0) {
            list.remove(0);
        }
        t = (BlancoSqlToken)list.get(list.size() - 1);
        if (t.type == 0) {
            list.remove(list.size() - 1);
        }
        block5: for (i2 = 0; i2 < list.size(); ++i2) {
            t = (BlancoSqlToken)list.get(i2);
            if (t.type != 2) continue;
            switch (this.rule.keyword) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    t.s = t.s.toUpperCase();
                    continue block5;
                }
                case 2: {
                    t.s = t.s.toLowerCase();
                }
            }
        }
        for (i2 = list.size() - 1; i2 >= 1; --i2) {
            t = (BlancoSqlToken)list.get(i2);
            BlancoSqlToken prev = (BlancoSqlToken)list.get(i2 - 1);
            if (t.type == 0 && (prev.type == 1 || prev.type == 5)) {
                list.remove(i2);
                continue;
            }
            if ((t.type == 1 || t.type == 5) && prev.type == 0) {
                list.remove(i2 - 1);
                continue;
            }
            if (t.type != 0) continue;
            t.s = " ";
        }
        for (i2 = list.size() - 1; i2 >= 2; --i2) {
            BlancoSqlToken t0 = (BlancoSqlToken)list.get(i2);
            BlancoSqlToken t1 = (BlancoSqlToken)list.get(i2 - 1);
            BlancoSqlToken t2 = (BlancoSqlToken)list.get(i2 - 2);
            if (t0.type != 2 || t1.type != 0 || t2.type != 2 || !t2.s.equalsIgnoreCase("ORDER") && !t2.s.equalsIgnoreCase("GROUP") || !t0.s.equalsIgnoreCase("BY")) continue;
            t2.s = t2.s + " " + t0.s;
            list.remove(i2 - 1);
            list.remove(i2 - 1);
        }
        int indent = 0;
        Stack<Integer> bracketIndent = new Stack<Integer>();
        for (i = 0; i < list.size(); ++i) {
            t = (BlancoSqlToken)list.get(i);
            if (t.type == 1) {
                if (t.s.equals("(")) {
                    bracketIndent.push(new Integer(indent));
                    i += this.insertReturnAndIndent(list, i + 1, ++indent);
                    continue;
                }
                if (t.s.equals(")")) {
                    indent = (Integer)bracketIndent.pop();
                    i += this.insertReturnAndIndent(list, i, indent);
                    continue;
                }
                if (t.s.equals(",")) {
                    i += this.insertReturnAndIndent(list, i, indent);
                    continue;
                }
                if (!t.s.equals(";")) continue;
                indent = 0;
                i += this.insertReturnAndIndent(list, i, indent);
                continue;
            }
            if (t.type == 2) {
                if (t.s.equalsIgnoreCase("DELETE") || t.s.equalsIgnoreCase("SELECT") || t.s.equalsIgnoreCase("UPDATE")) {
                    i += this.insertReturnAndIndent(list, i + 1, indent += 2);
                }
                if (t.s.equalsIgnoreCase("INSERT") || t.s.equalsIgnoreCase("INTO") || t.s.equalsIgnoreCase("CREATE") || t.s.equalsIgnoreCase("DROP") || t.s.equalsIgnoreCase("TRUNCATE") || t.s.equalsIgnoreCase("TABLE") || t.s.equalsIgnoreCase("CASE")) {
                    i += this.insertReturnAndIndent(list, i + 1, ++indent);
                }
                if (t.s.equalsIgnoreCase("FROM") || t.s.equalsIgnoreCase("WHERE") || t.s.equalsIgnoreCase("SET") || t.s.equalsIgnoreCase("ORDER BY") || t.s.equalsIgnoreCase("GROUP BY")) {
                    i += this.insertReturnAndIndent(list, i, indent - 1);
                    i += this.insertReturnAndIndent(list, i + 1, indent);
                }
                if (t.s.equalsIgnoreCase("VALUES")) {
                    i += this.insertReturnAndIndent(list, i, --indent);
                }
                if (t.s.equalsIgnoreCase("END")) {
                    i += this.insertReturnAndIndent(list, i, --indent);
                }
                if (t.s.equalsIgnoreCase("OR") || t.s.equalsIgnoreCase("AND") || t.s.equalsIgnoreCase("LEFT") || t.s.equalsIgnoreCase("THEN") || t.s.equalsIgnoreCase("ELSE")) {
                    i += this.insertReturnAndIndent(list, i, indent);
                }
                if (!t.s.equalsIgnoreCase("UNION")) continue;
                i += this.insertReturnAndIndent(list, i, indent -= 2);
                i += this.insertReturnAndIndent(list, i + 1, indent);
                continue;
            }
            if (t.type != 5 || !t.s.startsWith("/*")) continue;
            i += this.insertReturnAndIndent(list, i + 1, indent);
        }
        for (i = list.size() - 1; i >= 4; --i) {
            if (i >= list.size()) continue;
            BlancoSqlToken t0 = (BlancoSqlToken)list.get(i);
            BlancoSqlToken t1 = (BlancoSqlToken)list.get(i - 1);
            BlancoSqlToken t2 = (BlancoSqlToken)list.get(i - 2);
            BlancoSqlToken t3 = (BlancoSqlToken)list.get(i - 3);
            BlancoSqlToken t4 = (BlancoSqlToken)list.get(i - 4);
            if (!t4.s.equalsIgnoreCase("(") || !t3.s.trim().equalsIgnoreCase("") || !t1.s.trim().equalsIgnoreCase("") || !t0.s.equalsIgnoreCase(")")) continue;
            t4.s = t4.s + t2.s + t0.s;
            list.remove(i);
            list.remove(i - 1);
            list.remove(i - 2);
            list.remove(i - 3);
        }
        for (i = 1; i < list.size(); ++i) {
            BlancoSqlToken prev = (BlancoSqlToken)list.get(i - 1);
            t = (BlancoSqlToken)list.get(i);
            if (prev.type == 0 || t.type == 0 || prev.s.equals(",")) continue;
            list.add(i, new BlancoSqlToken(0, " "));
        }
        return list;
    }

    private int insertReturnAndIndent(List list, int index, int indent) {
        try {
            String s = "\n";
            BlancoSqlToken prev = (BlancoSqlToken)list.get(index - 1);
            if (prev.type == 5 && prev.s.startsWith("--")) {
                s = "";
            }
            for (int j = 0; j < indent; ++j) {
                s = s + this.rule.indentString;
            }
            BlancoSqlToken t = (BlancoSqlToken)list.get(index);
            if (t.type == 0) {
                t.s = s;
                return 0;
            }
            t = (BlancoSqlToken)list.get(index - 1);
            if (t.type == 0) {
                t.s = s;
                return 0;
            }
            list.add(index, new BlancoSqlToken(0, s));
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    public static void main(String[] args) throws Exception {
        BlancoSqlRule rule = new BlancoSqlRule();
        rule.keyword = 1;
        rule.indentString = "    ";
        BlancoSqlFormatter formatter = new BlancoSqlFormatter(rule);
        File[] files = new File("Test").listFiles();
        for (int i = 0; i < files.length; ++i) {
            String line;
            System.out.println("-- " + files[i]);
            BufferedReader reader = new BufferedReader(new FileReader(files[i]));
            String before = "";
            while (reader.ready() && (line = reader.readLine()) != null) {
                before = before + line + "\n";
            }
            reader.close();
            System.out.println("[before]\n" + before);
            String after = formatter.format(before);
            System.out.println("[after]\n" + after);
        }
    }
}

