/*
 * Decompiled with CFR 0.152.
 */
package blanco.plugin.sqleditor.editors;

import blanco.commons.sql.format.BlancoSqlFormatter;
import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.plugin.sqleditor.BlancoSqlEditorPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextEditorActionContributor;

public class BlancoSqlEditorContributor
extends TextEditorActionContributor {
    private Action menuAction = null;
    private IStatusLineManager statusLineManager = null;

    public BlancoSqlEditorContributor() {
        this.createActions();
    }

    private void createActions() {
        this.menuAction = new Action(){

            public void run() {
                block7: {
                    try {
                        TextEditor editor;
                        BlancoSqlEditorContributor.this.statusLineManager.setMessage(BlancoSqlEditorPlugin.getResourceString("MSG0001"));
                        IEditorPart activeEditor = BlancoSqlEditorContributor.this.getPage().getActiveEditor();
                        TextEditor textEditor = editor = activeEditor instanceof TextEditor ? (TextEditor)activeEditor : null;
                        if (editor != null) {
                            editor.showBusy(true);
                            String editorText = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
                            BlancoSqlFormatter formatter = new BlancoSqlFormatter(new BlancoSqlRule());
                            try {
                                String editorTextAfter = formatter.format(editorText);
                                if (!editorText.equals(editorTextAfter)) {
                                    editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set(editorTextAfter);
                                    editor.showChangeInformation(true);
                                    BlancoSqlEditorContributor.this.statusLineManager.setMessage(BlancoSqlEditorPlugin.getResourceString("MSG0002"));
                                } else {
                                    BlancoSqlEditorContributor.this.statusLineManager.setMessage(BlancoSqlEditorPlugin.getResourceString("MSG0003"));
                                }
                            }
                            catch (BlancoSqlFormatterException ex) {
                                BlancoSqlEditorContributor.this.statusLineManager.setMessage(String.valueOf(BlancoSqlEditorPlugin.getResourceString("MSG0004")) + ":" + ex.toString());
                            }
                            editor.showBusy(false);
                            break block7;
                        }
                        BlancoSqlEditorContributor.this.statusLineManager.setErrorMessage("fail to get editor during SQL formatting.");
                    }
                    catch (Exception ex) {
                        BlancoSqlEditorContributor.this.statusLineManager.setErrorMessage("unexpected exception occurs during SQL formatting." + ex.toString());
                    }
                }
            }
        };
        this.menuAction.setText(BlancoSqlEditorPlugin.getResourceString("MENU0002"));
        this.menuAction.setToolTipText(BlancoSqlEditorPlugin.getResourceString("MENU0002ToolTip"));
        this.menuAction.setAccelerator(393286);
        this.menuAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        MenuManager menu = new MenuManager(BlancoSqlEditorPlugin.getResourceString("MENU0001"));
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.menuAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        super.contributeToToolBar(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.menuAction);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        this.statusLineManager = statusLineManager;
    }
}

