/*
 * Decompiled with CFR 0.152.
 */
package blanco.plugin.sqleditor.editors;

import blanco.plugin.sqleditor.editors.ColorManager;
import blanco.plugin.sqleditor.editors.ISQLColorConstants;
import blanco.plugin.sqleditor.editors.NonRuleBasedDamagerRepairer;
import blanco.plugin.sqleditor.editors.SQLScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SQLConfiguration
extends SourceViewerConfiguration {
    private SQLScanner scanner;
    private ColorManager colorManager;

    public SQLConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__sql_comment", "__sql89_tag", "__sql92_tag", "__sql99_tag", "__sql_famous_tag", "__sql_string"};
    }

    protected SQLScanner getSQLScanner() {
        if (this.scanner == null) {
            this.scanner = new SQLScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISQLColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getSQLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(ISQLColorConstants.SQL_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__sql_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__sql_comment");
        return reconciler;
    }
}

