/*
 * Decompiled with CFR 0.152.
 */
package blanco.plugin.sqleditor.popup;

import blanco.commons.sql.format.BlancoSqlFormatter;
import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class BlancoSqlFormatAction
implements IEditorActionDelegate {
    private IWorkbenchPart activeEditor = null;
    private ITextSelection activeSelection = null;
    private BlancoSqlFormatter formatter = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.activeSelection = (ITextSelection)selection;
        }
    }

    public void run(IAction action) {
        if (this.activeEditor != null) {
            if (this.formatter == null) {
                this.formatter = new BlancoSqlFormatter(new BlancoSqlRule());
            }
            try {
                this.getDocument().replace(this.activeSelection.getOffset(), this.activeSelection.getLength(), this.formatter.format(this.activeSelection.getText()));
            }
            catch (BlancoSqlFormatterException blancoSqlFormatterException) {
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected IDocument getDocument() {
        if (this.activeEditor != null && this.activeEditor instanceof AbstractTextEditor) {
            AbstractTextEditor editor = (AbstractTextEditor)this.activeEditor;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            return document;
        }
        return null;
    }
}

