package blanco.plugin.dbee.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.exception.BlancoDbException;
import blanco.db.helper.BlancoDbDefaultGenerator;
import blanco.db.helper.BlancoDbExcel2Xml;
import blanco.db.helper.BlancoDbTableGateway2Xml;
import blanco.plugin.dbee.editors.BlancoDbEEPluginUtil;

public class BlancoDbEEGenerateAction implements IObjectActionDelegate {

    private ISelection selection;

    public BlancoDbEEGenerateAction() {
        super();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = new Shell();

        if (selection instanceof StructuredSelection) {
            StructuredSelection look = (StructuredSelection) selection;
            Object objectLook = look.getFirstElement();
            if (objectLook instanceof IFile) {
                // ܂Ă܂B
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /**
     * blancoDb\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void processBlancoDb(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String metaDir, final String jdbcDriver,
            final String jdbcUrl, final String jdbcUser,
            final String jdbcPassword, final String jdbcSchema,
            final String basePackage, final boolean isSimpleTableProcess,
            final boolean isSqlMetaProcess) throws InvocationTargetException,
            InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask("blancoDb\[XR[h", 10);

                                // ڑ̍\z
                                BlancoDbDatabaseConnectionSettingDef connDef = new BlancoDbDatabaseConnectionSettingDef();
                                connDef.setJdbcDriver(jdbcDriver);
                                connDef.setJdbcUrl(jdbcUrl);
                                connDef.setJdbcUser(jdbcUser);
                                connDef.setJdbcPassword(jdbcPassword);
                                if (jdbcSchema != null
                                        && jdbcSchema.length() > 0) {
                                    // XL[}wB
                                    // w肪ꍇɂ̂݃Zbĝ@łB
                                    connDef.setSchema(jdbcSchema);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: blancotH_̍쐬");
                                monitor.worked(1);

                                // blancotH_΍ŏɍ쐬܂B
                                IFolder folderTargetDirectoryBlanco = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryBlanco.create(true,
                                            true, workbenchMonitor);
                                }
                                File blancoTargetDirectory = folderTargetDirectoryBlanco
                                        .getLocation().toFile();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSimpleTableProcess) {
                                    processSimpleTable(ifile, shell,
                                            workbenchMonitor, basePackage,
                                            connDef, blancoTargetDirectory,
                                            monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSqlMetaProcess) {
                                    processSqlMeta(ifile, shell,
                                            workbenchMonitor, metaDir,
                                            basePackage, connDef,
                                            blancoTargetDirectory, monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: blancotH_tbV");
                                monitor.worked(1);

                                folderTargetDirectoryBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: blancotH_tbV");

                                // tmptH_𓯊
                                BlancoDbEEPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, "tmp");

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: sqltH_tbV");
                                // ܂łیƂē܂B
                                BlancoDbEEPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, metaDir);
                            } catch (CoreException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (SQLException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (BlancoDbException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (SAXException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (IOException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (ParserConfigurationException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n"
                            + ex.getTargetException().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        } finally {
        }
    }

    /**
     * P\܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     */
    private static void processSimpleTable(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String basePackage,
            final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoTargetDirectory, final IProgressMonitor monitor)
            throws InvocationTargetException, InterruptedException,
            CoreException, SQLException, BlancoDbException, SAXException,
            IOException, ParserConfigurationException {
        // TableGatewayp̃e|tH_͈U폜܂B
        monitor.subTask("P\: e|tH_𐮗܂B");
        BlancoDbEEPluginUtil.deleteFolder(ifile, workbenchMonitor,
                "tmp/db/table");
        BlancoDbEEPluginUtil.createFolder(ifile, workbenchMonitor,
                "tmp/db/table");
        File blancoTempDirectoryTable = ifile.getProject().getFolder(
                "tmp/db/table").getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: f[^x[X̒P\^擾܂B");
        monitor.worked(1);

        BlancoDbTableGateway2Xml gateway = new BlancoDbTableGateway2Xml() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): \[" + progressItem + "]𒊏o");
                return true;
            }
        };
        gateway.process(connDef, blancoTempDirectoryTable);

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: ^Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // TableGatewayXMLt@CR/O}bsO
        BlancoDbDefaultGenerator generatorTable = new BlancoDbDefaultGenerator() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): t@C[" + progressItem + "]R/O}bsO");
                return true;
            }
        };
        generatorTable.process(connDef, blancoTempDirectoryTable, basePackage,
                blancoTargetDirectory.toString());

    }

    /**
     * SQL`t@C܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     */
    private static void processSqlMeta(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final String basePackage,
            final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoTargetDirectory, final IProgressMonitor monitor)
            throws InvocationTargetException, InterruptedException,
            CoreException, SQLException, BlancoDbException, SAXException,
            IOException, ParserConfigurationException {
        monitor.subTask("SQL`t@C: e|tH_𐮗܂B");
        monitor.worked(1);

        // SQL`t@Cɂ鐶
        BlancoDbEEPluginUtil
                .deleteFolder(ifile, workbenchMonitor, "tmp/db/sql");
        BlancoDbEEPluginUtil
                .createFolder(ifile, workbenchMonitor, "tmp/db/sql");
        File blancoSqlDirectory = ifile.getProject().getFolder(metaDir)
                .getLocation().toFile();

        File blancoTempDirectorySql = ifile.getProject()
                .getFolder("tmp/db/sql").getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("SQL`t@C: SQL`Ƃɒԃt@C(XML)𐶐܂B");
        monitor.worked(1);

        // Excelt@CXMLt@C܂B
        new BlancoDbExcel2Xml(blancoSqlDirectory, blancoTempDirectorySql) {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("SQL`t@C(" + progressCurrent + "/"
                        + progressTotal + "): t@C[" + progressItem + "]𒊏o");
                return true;
            }
        }.processAllFiles();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("SQL`t@C: Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // SQL`t@CXMLt@CR/O}bsO
        BlancoDbDefaultGenerator generatorSql = new BlancoDbDefaultGenerator() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("SQL`t@C(" + progressCurrent + "/"
                        + progressTotal + "): t@C[" + progressItem
                        + "]R/O}bsO");
                return true;
            }

        };
        generatorSql.process(connDef, blancoTempDirectorySql, basePackage,
                blancoTargetDirectory.toString());
    }
}