package blanco.plugin.dbee.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BlancoDbEEPluginUtil {
    /**
     * vWFNg wtH_XV܂B
     * 
     * @param input
     * @param monitor
     * @param folderName
     * @return
     * @throws CoreException
     */
    public static boolean refreshFolder(IFile input, IProgressMonitor monitor,
            String folderName) throws CoreException {
        IFolder folderCheck = input.getProject().getFolder(folderName);
        if (folderCheck.exists()) {
            folderCheck.refreshLocal(IResource.DEPTH_INFINITE, monitor);
            return true;
        }
        return false;
    }

    /**
     * vWFNg wtH_쐬܂B
     * 
     * @param input
     * @param monitor
     * @param folderName
     * @return
     * @throws CoreException
     */
    public static void createFolder(IFile input, IProgressMonitor monitor,
            String folderName) throws CoreException {
        IFolder folderCurrent = null;
        for (boolean found = false; found == false;) {
            if (folderName.indexOf('/') < 0) {
                found = true;
                if (folderCurrent == null) {
                    folderCurrent = input.getProject().getFolder(folderName);
                } else {
                    folderCurrent = folderCurrent.getFolder(folderName);
                }
            } else {
                String nextFolder = folderName.substring(0, folderName
                        .indexOf('/'));
                folderName = folderName.substring(folderName.indexOf('/') + 1);
                if (folderCurrent == null) {
                    folderCurrent = input.getProject().getFolder(nextFolder);
                } else {
                    folderCurrent = folderCurrent.getFolder(nextFolder);
                }
            }
            if (folderCurrent.exists() == false) {
                folderCurrent.create(true, true, monitor);
            }
        }
    }

    /**
     * vWFNg wtH_쐬܂B
     * 
     * @param input
     * @param monitor
     * @param folderName
     * @return
     * @throws CoreException
     */
    public static IFolder findFolder(IFile input, IProgressMonitor monitor,
            String folderName) throws CoreException {
        IFolder folderCurrent = null;
        for (boolean found = false; found == false;) {
            if (folderName.indexOf('/') < 0) {
                found = true;
                if (folderCurrent == null) {
                    folderCurrent = input.getProject().getFolder(folderName);
                } else {
                    folderCurrent = folderCurrent.getFolder(folderName);
                }
            } else {
                String nextFolder = folderName.substring(0, folderName
                        .indexOf('/'));
                folderName = folderName.substring(folderName.indexOf('/') + 1);
                if (folderCurrent == null) {
                    folderCurrent = input.getProject().getFolder(nextFolder);
                } else {
                    folderCurrent = folderCurrent.getFolder(nextFolder);
                }
            }
        }
        return folderCurrent;
    }

    /**
     * vWFNg wtH_폜܂B
     * 
     * @param input
     * @param monitor
     * @param folderName
     * @return
     * @throws CoreException
     */
    public static void deleteFolder(IFile input, IProgressMonitor monitor,
            String folderName) throws CoreException {
        IFolder folder = findFolder(input, monitor, folderName);
        if (folder != null) {
            folder.delete(true, monitor);
        }
    }
}
