/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * Native2AsciiC^[
 * 
 * @author IGA Tosiki
 */
public class Native2AsciiWriter {
    private BufferedWriter writer;

    /**
     * {Iɂ́A8859_1GR[h̃C^[nĂB
     * 
     * @param writer
     */
    public Native2AsciiWriter(final BufferedWriter writer) {
        this.writer = writer;
    }

    /**
     * C^[N[Y܂B
     * 
     * @throws IOException
     */
    public void close() throws IOException {
        writer.close();
    }

    /**
     * C^[ɃRgo͂܂B
     * 
     * @param comment
     * @throws IOException
     */
    public void writeComment(final String comment) throws IOException {
        writer.write("# " + comment);
        writer.newLine();
    }

    /**
     * C^[ɃvpeBo͂܂B
     * 
     * @param key
     * @param value
     * @throws IOException
     */
    public void writeProperty(final String key, final String value)
            throws IOException {
        writer.write(encodeNative2Ascii(key, true));
        writer.write("=");
        writer.write(encodeNative2Ascii(value, false));
        writer.newLine();
    }

    /**
     * native2asciis܂B
     * 
     * @param nativeString
     * @param isKey
     * @return
     */
    public static final String encodeNative2Ascii(final String nativeString,
            final boolean isKey) {
        StringReader reader = new StringReader(nativeString);
        StringWriter writer = new StringWriter();
        try {
            for (boolean isFirstChar = true;; isFirstChar = false) {
                int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch ((char) iRead) {
                // \\\t\f\n\r
                case '\\':
                case '\t':
                case '\f':
                case '\n':
                case '\r':
                // #!=:
                case '#':
                case '!':
                case '=':
                case ':':
                    writer.write('\\');
                    writer.write((char) iRead);
                    break;
                case ' ':
                    if (isKey) {
                        // L[̏ꍇɂ́AXy[X̓obNXbVŃGXP[v܂B
                        writer.write('\\');
                        writer.write(' ');
                    } else {
                        if (isFirstChar) {
                            // l̏ꍇA̕擪łꍇɂ̂݃GXP[v܂B
                            writer.write('\\');
                        }
                        writer.write(' ');
                    }
                    break;
                default:
                    if ((iRead < 0x0020) || (iRead > 0x007E)) {
                        // \u0020̂ \u007E傫̂
                        // \\uxxxx̂悤16i\s܂B
                        writer.write(toHexString((char) iRead));
                    } else {
                        // Â܂܏o܂B
                        writer.write((char) iRead);
                    }
                }
            }
            writer.flush();
            return writer.toString();
        } catch (IOException e) {
            // ܂͂肦܂B
            e.printStackTrace();
            return null;
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    // ܂͂肦܂B
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /**
     * ^ꂽcharUnicode\Lɕϊ܂B
     * 
     * @param arg
     * @return
     */
    public static final String toHexString(final char arg) {
        String strResult = Integer.toHexString(arg).toUpperCase();
        for (; strResult.length() < 4;) {
            strResult = "0" + strResult;
        }
        return "\\u" + strResult;
    }
}
