/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public final class BlancoJavaSourceUtil {
    /**
     * ͂Java\[XR[hɕϊ̂ƂăGXP[vs܂B<br>
     * CWFNVUȂǂɂ͑ΉĂ܂B
     * 
     * @param arg
     *            ͕
     * @return GXP[v̕
     */
    public static final String escapeStringAsJavaSource(final String arg) {
        final StringReader reader = new StringReader(arg);
        final StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch (iRead) {
                case '\\':
                    writer.write("\\\\");
                    break;
                case '\n':
                    writer.write("\\n");
                    break;
                case '"':
                    writer.write("\\\"");
                    break;
                default:
                    writer.write((char) iRead);
                    break;
                }
            }
            writer.flush();
        } catch (IOException e) {
            // ܂ 肦܂B
            e.printStackTrace();
        }
        return writer.toString();
    }
}
