/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import blanco.db.alias.AliasProcessor;
import blanco.db.collector.BlancoDbCollector;
import blanco.db.collector.BlancoDbDatabaseConnection;
import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.BlancoDbDefinition;
import blanco.db.exception.BlancoDbException;
import blanco.db.generator.BlancoDbGenerator;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDb {
    private BlancoDbSetting _setting = null;

    private BlancoDbDefinition _definition = null;

    public BlancoDb(BlancoDbSetting setting) {
        _setting = setting;
    }

    private void validateSetting() {
        File f = new File(_setting.getQueryDirectory());
        if (!f.exists()) {
            String message = "NGfBNg݂܂BPath:" + f.getAbsolutePath();
            throw new RuntimeException(message);
        }

        if (!f.isDirectory()) {
            String message = "NGfBNgɃt@Cw肳Ă܂BFile:"
                    + f.getAbsolutePath();
            throw new RuntimeException(message);
        }
    }

    public void generate(BlancoDbMetadata metadata,
            BlancoDbDatabaseConnection conn) throws SQLException, SAXException,
            IOException, ParserConfigurationException, BlancoDbException {
        BlancoDbCollector collector = null;

        collector = new BlancoDbCollector(_setting);
        _definition = collector.collect(metadata, conn);

        AliasProcessor processor = new AliasProcessor(_setting, _definition);
        processor.apply();

        validateSetting();
        validateDefinition();

        BlancoDbGenerator _generator = null;
        _generator = new BlancoDbGenerator(_setting);
        _generator.setup(_definition);
        _generator.generate();
    }

    /**
     * TableGatewaŷݍ쐬܂B <br>
     * ̃\bh̗p͐܂B
     * 
     * @param metadata
     * @param conn
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     */
    public void generateTableGateway(BlancoDbMetadata metadata,
            BlancoDbDatabaseConnection conn) throws SQLException, SAXException,
            IOException, ParserConfigurationException, BlancoDbException {
        BlancoDbCollector collector = null;

        collector = new BlancoDbCollector(_setting);
        _definition = collector.collectTableGateway(metadata, conn);

        AliasProcessor processor = new AliasProcessor(_setting, _definition);
        processor.apply();

        validateSetting();
        validateDefinition();

        BlancoDbGenerator _generator = null;
        _generator = new BlancoDbGenerator(_setting);
        _generator.setupTableGateway(_definition);
        _generator.generate();
    }

    private void validateDefinition() {
        if (_definition.getTargetObjectCount() == 0) {
            System.out.println("ΏۂSQLݒ𔺂IuWFNg܂B");
        }
    }
}