/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.alias;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import blanco.db.alias.pool.AliasLoader;
import blanco.db.alias.pool.AliasPool;
import blanco.db.alias.pool.AliasReportWriter;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.BlancoDbDefinition;
import blanco.db.definition.TableField;
import blanco.db.definition.TableGateway;

/**
 * @author Yasuo Nakanishi
 */
public class AliasProcessor {
    private BlancoDbSetting _setting = null;

    private AliasPool _aliasPool = null;

    private BlancoDbDefinition _definition = null;

    private NameTranslator _translator = null;

    public AliasProcessor(BlancoDbSetting setting, BlancoDbDefinition definition) {
        _setting = setting;
        _definition = definition;

        if (_setting.isEnableNameTranslator()) {
            _translator = _setting.getNameTranslator();
        }
    }

    public void apply() throws SAXException, IOException,
            ParserConfigurationException {

        TableGateway gateway = null;
        String name = "";

        if (_setting.isEnableAliasPool()) {
            AliasLoader loader = new AliasLoader(_setting);
            _aliasPool = loader.load();
        }

        for (int i = 0; i < _definition.getTableGatewayCount(); i++) {
            gateway = _definition.getTableGateway(i);
            name = gateway.getDbName();

            if (_setting.isEnableNameTranslator()
                    && _translator.isThroughTableName(name)) {
                name = _translator.getTableName(name);
                gateway.setAlias(name);
            }
            if (_setting.isEnableAliasPool()) {
                if (_aliasPool.findAlias(name)) {
                    gateway.setAlias(_aliasPool.getAlias(name));
                }
            }
            appleyAliasToTableGatewayFieldFields(i);
        }

        if (_setting.isEnableAliasPool()) {
            AliasReportWriter writer = new AliasReportWriter(_setting);
            writer.write(_aliasPool);
        }
    }

    private void appleyAliasToTableGatewayFieldFields(int gatewayIndex) {
        TableGateway gateway = _definition.getTableGateway(gatewayIndex);

        TableField field = null;
        String name = "";
        for (int i = 0; i < gateway.getFiledCount(); i++) {
            field = gateway.getField(i);
            name = field.getJdbcName();

            if (_setting.isEnableNameTranslator()
                    && _translator.isThroughFieldName(name)) {
                name = _translator.getFieldName(name);
                gateway.setAlias(name);
            }
            if (_setting.isEnableAliasPool()) {
                if (_aliasPool.findAlias(name)) {
                    field.setAlias(_aliasPool.getAlias(name));
                }
            }
        }
    }
}