/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.alias.pool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import blanco.ig.tool.ConsolePrinter;

/**
 * @author Yasuo Nakanishi
 */
public class AliasPool {
    private Map _aliasMap = new TreeMap();

    private List _notFindedNameList = new ArrayList();

    private ConsolePrinter _printer = ConsolePrinter.get();

    public void addAlias(Alias alias) {
        String name = alias.getName();
        if (_aliasMap.containsKey(name)) {
            _printer.printWarning("ÕGCAXłɓo^Ă܂BName:" + name);
        }
        _aliasMap.put(name, alias);
    }

    public Iterator getNotMatchedAliasIterator() {
        return _aliasMap.values().iterator();
    }

    public Iterator getNotFindedNameIterator() {
        return _notFindedNameList.iterator();
    }

    public boolean findAlias(String name) {
        boolean result = _aliasMap.containsKey(name);
        if (!result) {
            _notFindedNameList.add(name);
        }
        return result;
    }

    public String getAlias(String name) {
        //assert findAlias(name);
        Alias a = (Alias) _aliasMap.get(name);
        a.setMached();
        return a.getAlias();
    }
}