/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbMetadata {
    private String _name = "";

    private String _middleNameSpace = "";

    private TableGenerate _tableGenerate = TableGenerate.DATABASE;

    private List _tableList = new ArrayList();

    private List _selectQueryList = new ArrayList();

    private List _executeQueryList = new ArrayList();

    public BlancoDbMetadata() {
    }

    public BlancoDbMetadata(String name) {
        _name = name;
    }

    public BlancoDbMetadata(String name, String middleNameSpace) {
        _name = name;
        _middleNameSpace = middleNameSpace;
    }

    public static BlancoDbMetadata createTableGate(String name) {
        BlancoDbMetadata gate = new BlancoDbMetadata(name);
        gate.setTableGenerate(TableGenerate.DATABASE);
        return gate;
    }

    public String getName() {
        return _name;
    }

    public TableGenerate getTableGenerate() {
        return _tableGenerate;
    }

    public void setTableGenerate(TableGenerate generate) {
        _tableGenerate = generate;
    }

    public int getTableCount() {
        return _tableList.size();
    }

    public Table getTable(int index) {
        return (Table) _tableList.get(index);
    }

    public void addTable(Table table) {
        if (_tableGenerate.equals(TableGenerate.DATABASE)) {
            _tableGenerate = TableGenerate.TABLE;
        }
        _tableList.add(table);
    }

    public int getSelectQueryCount() {
        return _selectQueryList.size();
    }

    public SelectQuery getSelectQuery(int index) {
        return (SelectQuery) _selectQueryList.get(index);
    }

    public void addSelectQuery(SelectQuery query) {
        _selectQueryList.add(query);
    }

    public int getExecuteQueryCount() {
        return _executeQueryList.size();
    }

    public ExecuteQuery getExecuteQuery(int index) {
        return (ExecuteQuery) _executeQueryList.get(index);
    }

    public void addExecuteQuery(ExecuteQuery query) {
        _executeQueryList.add(query);
    }

    public String getMiddleNamespace() {
        return _middleNameSpace;
    }
}