/*
 * blancoDb
 * Copyright (C) 2004-2005 Kazuhisa Izawa
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf.jdbc;

import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;

/**
 * @author Kazuhisa Izawa
 */
public class OracleSetting extends BlancoDbDatabaseConnectionSettingDef {

    public OracleSetting(String server, String strSchema) {
        setJdbcDriver("oracle.jdbc.driver.OracleDriver");
        setJdbcUrl("jdbc:oracle:thin:@" + server + ":1521:orcl");
        setSchema(strSchema);
    }

    public OracleSetting(String server, int port, String sid, String strSchema) {
        setJdbcDriver("oracle.jdbc.driver.OracleDriver");
        setJdbcUrl("jdbc:oracle:thin:@" + server + ":" + port + ":" + sid);
        setSchema(strSchema);
    }
}