/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.Iterator;

import blanco.db.conf.QueryPath;
import blanco.db.conf.SelectQuery;

/**
 * @author Yasuo Nakanishi
 */
public class QueryIterator {

    private SelectQuery _selectQuery = null;

    public QueryIterator(SelectQuery selectQuery) {
        _selectQuery = selectQuery;
    }

    public QueryPath getPath() {
        return _selectQuery.getQueryPath();
    }

    public String getFilePath() {
        return _selectQuery.getFilePath();
    }

    public int getFieldCount() {
        return _selectQuery.getParameterList().size();
    }

    public QueryField getField(int index) {
        return (QueryField) _selectQuery.getParameterList().get(index);
    }

    public Iterator getFieldIterator() {
        return _selectQuery.getFieldIterator();
    }

    public String getName() {
        return _selectQuery.getName();
    }

    public Iterator getParameterIterator() {
        return _selectQuery.getParameterIterator();
    }

    public boolean isEnableGetAsObject() {
        return _selectQuery.isEnableGetAsObject();
    }

    public String getQuery() {
        return _selectQuery.getQuery();
    }

    public void setQuery(String query) {
        _selectQuery.setQuery(query);
    }

    public String getScrollInterface() {
        return _selectQuery.getScrollInterface();
    }

    public boolean isEnableUpdatableInterface() {
        return _selectQuery.isEnableUpdatableInterface();
    }

    public boolean isSingle() {
        return _selectQuery.isSingle();
    }
}