/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

/**
 * f[^x[X̏̌ʁA1sf[^ύXȂƂONX <br>
 * ̃NXblancoDb\[XR[hŗp܂ <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @since 2005.05.12
 * @author Tosiki Iga
 */
public class NoRowModifiedException extends NotSingleRowException {
    /**
     * SQLState͉̒lƂĐݒ肵Ă܂B <br>
     * vO SQLStateɗ炸 ONXɂĔf悤ɂĂB
     */
    private static final String SQLSTATE_NOROWMODIFIED = "00102";

    /**
     * f[^x[X̏̌ʁA1sf[^ύXȂƂONX̃CX^X𐶐܂B <br>
     * 
     * @deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B
     */
    public NoRowModifiedException() {
        super("No row modified exception has occured.", SQLSTATE_NOROWMODIFIED);
    }

    /**
     * f[^x[X̏̌ʁA1sf[^ύXȂƂONX̃CX^X𐶐܂B <br>
     * 
     * @param reason
     * @param SQLState
     */
    public NoRowModifiedException(String reason) {
        super(reason, SQLSTATE_NOROWMODIFIED);
    }

    /**
     * f[^x[X̏̌ʁA1sf[^ύXȂƂONX̃CX^X𐶐܂B <br>
     * 
     * @param reason
     * @param SQLState
     */
    public NoRowModifiedException(String reason, String SQLState) {
        super(reason, SQLState);
    }

    /**
     * f[^x[X̏̌ʁA1sf[^ύXȂƂONX̃CX^X𐶐܂B <br>
     * 
     * @param reason
     * @param SQLState
     * @param vendorCode
     */
    public NoRowModifiedException(String reason, String SQLState, int vendorCode) {
        super(reason, SQLState, vendorCode);
    }
}