/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.SQLException;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class PrepareStatementMethod extends MethodExpander {
    private BlancoDbSetting _setting = null;

    private GenerationProperties _properties = null;

    public PrepareStatementMethod() {
        super("prepareStatement");

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _properties = storage.getGenerationProperties();
    }

    public void setupSignature() {
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("NG̃vRpC{܂B<br>");
            getJavaDoc().addLine("Iɂ Connection.prepareStatement Ăяo܂B");
            getJavaDoc().addLine("炩ߗ^ĂNG(SQL)𗘗p܂B");
        }
    }

    public void implement() {
        Receiver r = null;
        Implementor i = new Implementor(getData());
        i.addStatement("close()");
        i.addStatement("prepareStatement(getQuery())");
    }
}