/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.SQLException;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.QueryIterator;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareStatementMethod2 extends MethodExpander {
    private BlancoDbSetting _setting = null;

    private Value queryArgument = new Value(String.class, "query");

    private GenerationProperties _properties = null;

    private QueryIterator _iterator = null;

    public PrepareStatementMethod2(QueryIterator iterator) {
        super("prepareStatement");

        _iterator = iterator;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _properties = storage.getGenerationProperties();
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("NG̃vRpC{܂B<br>");
            getJavaDoc().addLine("Iɂ Connection.prepareStatement Ăяo܂B");
            getJavaDoc().addParameter("query", "pNG(SQL)");
        }
    }

    public void implement() {
        Receiver r = null;
        Implementor i = new Implementor(getData());
        i.addStatement("close()");

        if (_iterator == null) {
            i.addStatement("_statement = _connection.prepareStatement(query)");
        } else if (_iterator.getScrollInterface().equals("forward_only")
                && _iterator.isEnableUpdatableInterface() == false) {
            i.addStatement("_statement = _connection.prepareStatement(query)");
        } else {
            String resultSetType = "ResultSet.TYPE_FORWARD_ONLY";
            String resultSetConcurrency = "ResultSet.CONCUR_READ_ONLY";
            if (_iterator.getScrollInterface().equals("insensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (_iterator.getScrollInterface().equals("sensitive")) {
                resultSetType = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            if (_iterator.isEnableUpdatableInterface()) {
                resultSetConcurrency = "ResultSet.CONCUR_UPDATABLE";
            }
            i.addStatement("_statement = _connection.prepareStatement(query, "
                    + resultSetType + ", " + resultSetConcurrency + ")");
        }
    }
}