/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * J[\truȅꍇɁÃ\bh͍쐬܂B
 * 
 * @author Tosiki Iga
 */
public class AbsoluteMethod extends MethodExpander {
    private GenerationProperties _properties = null;

    private QueryIterator _iterator = null;

    public AbsoluteMethod(QueryIterator iterator) {
        super("absolute");

        _iterator = iterator;
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();
    }

    public void setupSignature() {
        setReturnType(new Type(boolean.class));
        addException(SQLException.class);

        addArgument(new Value(int.class, "rows"));

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("J[\ʃZbg̎w肳ꂽsֈړ܂B");
            getJavaDoc().addLine("absolute(1)first()ĂяôƓłB");
            getJavaDoc().addLine("absolute(-1)last()ĂяôƓłB");
            getJavaDoc().addReturn("V݂̍sLȏꍇtrueAȏ̍sȂꍇfalse");
        }
    }

    public void implement() {
        Implementor i = new Implementor(getData());

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        i.addLine("if (_resultSet == null) {");
        i.addStatement("executeQuery()");
        i.addLine("}");

        i.addStatement("return _resultSet.absolute(rows)");
    }
}