/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.QueryField;
import blanco.db.definition.QueryIterator;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class UpdateObjectMethod extends MethodExpander {
    private Value _resultSet = null;

    private Value _statement = null;

    private QueryField _field = null;

    private BlancoDbSetting _setting = null;

    private QueryIterator _iterator = null;

    private GenerationProperties _properties = null;

    public UpdateObjectMethod(QueryIterator iterator, QueryField field) {
        super("update"
                + getNameAdjuster().toTitleCase(
                        getNameAdjuster().toValueName(field.getName())));

        _iterator = iterator;
        _field = field;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _properties = storage.getGenerationProperties();
    }

    public void setupSignature() {
        addException(SQLException.class);

        Value value = new Value(_field.getJavaType(), getNameAdjuster()
                .toValueName(_field.getName()));
        addArgument(value);

        if (_field.getTypeName().equals("InputStream")
                || _field.getTypeName().equals("Reader")) {
            addArgument(new Value(int.class, "sourceLength"));
        }

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("'" + _field.getName() + "'XV܂B<br>");
            getJavaDoc().addParameter(
                    getNameAdjuster().toValueName(_field.getName()),
                    _field.getName() + "ɃZbgl");
        }
    }

    public void implement() {
        BlancoDbImplementor i = new BlancoDbImplementor(getData());

        i.addUsingType(new Type(_setting.getRootNameSpace()
                + ".util.BlancoDbUtil"));

        _resultSet = getField("ResultSet");

        Receiver r = null;
        Call c = null;
        r = new Receiver(_resultSet);

        if (_field.getObjectMappingForPrimitiveNullSupport()) {
            i.openIf(getNameAdjuster().toValueName(_field.getName())
                    + " == null");
            i.addStatement("_resultSet.updateNull("
                    + new StringLiteral(_field.getName()) + ")");
            i.addElse();
        }

        c = r.call(BlancoDbMappingUtil.getResultSetUpdateMethodName(_field
                .getTypeName()));

        c.addArgument(new StringLiteral(_field.getJdbcName()));

        c.addArgument(BlancoDbMappingUtil.mapWrapperClassIntoPrimitive(
                getNameAdjuster().toValueName(_field.getName()), _field
                        .getTypeName()));

        if (_field.getTypeName().equals("Date")) {
            c.addUsingType(new Type(java.sql.Timestamp.class));
        }

        if (_field.getTypeName().equals("InputStream")
                || _field.getTypeName().equals("Reader")) {
            c.addArgument(new Value(int.class, "sourceLength"));
        }

        i.addStatement(r);

        if (_field.getObjectMappingForPrimitiveNullSupport()) {
            i.closeIf();
        }

        if (_setting.isEnabledLogging()) {
            i.outLog(_statement);
        }
    }
}