/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway;

import java.sql.SQLException;
import java.util.Iterator;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.TableField;
import blanco.db.definition.TableGateway;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class DeleteMethod extends TableGatewayMethod {
    private TypeFactory _typeFactory = null;

    private BlancoDbSetting _setting = null;

    private String _query = "";

    private GenerationProperties _properties = null;

    public DeleteMethod(TableGateway gateway, String query) {
        super("delete", gateway);

        _query = query;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _typeFactory = storage.getTypeFactory();
        _properties = storage.getGenerationProperties();
    }

    public void setupSignature() {
        setReturnType(new Type(void.class));

        TableField field = null;
        Iterator i = getGateway().getPrimaryKeyFieldIterator();
        while (i.hasNext()) {
            field = (TableField) i.next();
            addArgument(createPrimaryKeyArgument(field));
        }

        addException(new Type(SQLException.class));

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("\s폜܂B");

            i = getGateway().getPrimaryKeyFieldIterator();
            String name = "";
            while (i.hasNext()) {
                field = (TableField) i.next();
                name = field.getName();
                getJavaDoc().addParameter(getNameAdjuster().toValueName(name),
                        "'" + name + "'̒l");
            }
        }
    }

    public void implement() {
        NameAdjuster adjuster = new NameAdjuster();
        BlancoDbImplementor implementor = getImplementor();

        String simpleClassName = "Simple" + getGateway().getClassName()
                + "DeleteInvoker";
        implementor.addUsingType(new Type(_setting.getRootNameSpace()
                + ".query." + simpleClassName));
        implementor.addStatement(simpleClassName + " invoker = new "
                + simpleClassName + "(_connection)");
        implementor.openTry();

        TableField field = null;
        Iterator i = getGateway().getFieldIterator();
        String strInputParameter = "";
        while (i.hasNext()) {
            field = (TableField) i.next();
            if (field.isPrimaryKey() == false) {
                continue;
            }
            if (strInputParameter.length() > 0) {
                strInputParameter += ", ";
            }
            strInputParameter += adjuster.toValueName(field.getName());
            if (field.getTypeName().equals("InputStream")
                    || field.getTypeName().equals("Reader")) {
                strInputParameter += ", 10000";
            }
        }

        implementor.addStatement("invoker.setInputParameter("
                + strInputParameter + ")");
        implementor.addStatement("invoker.executeSingleUpdate()");

        implementor.addFinally();
        implementor.addStatement("invoker.close()");
        implementor.closeTry();
    }
}