/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway;

import java.sql.Connection;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.conf.Logging;
import blanco.db.definition.TableGateway;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.field.PrivateField;
import blanco.ig.expander.implementor.Call;

/**
 * @author Yasuo Nakanishi
 */
public class TableGatewayClass extends ClassExpander {

    private BlancoDbSetting _setting = null;

    private TableGateway _gateway = null;

    private TableGatewayMethodFactory _methodFactory = null;

    private GenerationProperties _properties = null;

    private TypeFactory _factory = null;

    public TableGatewayClass(Type type, TableGateway gateway) {
        super(type);

        _gateway = gateway;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _properties = storage.getGenerationProperties();
        _factory = storage.getTypeFactory();

        _methodFactory = new TableGatewayMethodFactory(_gateway);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine(_gateway.getClassName() + "NX<br>");
            getJavaDoc().addLine("TableGatewayɑNXłB<br>");
            getJavaDoc().addLine("DB̃e[ubsOĊeANZT񋟂܂B");
        }
    }

    public void expandClassStruct() {
        //addImport(new Type(_setting.getRootNameSpace()
        //		+ ".util.BlancoDbUtil"));

        Value connection = new Value(Connection.class, "Connection");
        addField(new PrivateField(connection));

        if (_setting.getLogging().equals(Logging.LOG4J)) {
            Value logger = new Value(new Type("org.apache.log4j.Logger"),
                    "Logger");
            FieldExpander field = new PrivateField(logger);
            Call c = new Call(logger.getType(), "getLogger");
            c.addArgument(new Call("getClass"));
            field.setDefaultStatement(c);
            addField(field);
        }

        addMethod(new TableGatewayConstructor(getName()));

        if (_gateway.exsistPrimaryKey()) {
            addMethod(_methodFactory.createSelect());
            addMethod(_methodFactory.createSelectAll());
            addMethod(_methodFactory.createInsert());

            if (_gateway.hasDataField()) {
                addMethod(_methodFactory.createUpdate());
            }
            addMethod(_methodFactory.createDelete());

        }

        if (_setting.getLogging().equals(Logging.LOG4J)) {
            addMethod(_methodFactory.createOutLog());
        }
    }

}