/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway;

import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.TableGateway;
import blanco.db.expander.log.OutLogMethod;
import blanco.db.expander.log.PrintConsoleMethod;
import blanco.db.expander.table.gateway.sql.SqlGenerator;
import blanco.db.expander.table.gateway.sql.SqlGeneratorFactory;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class TableGatewayMethodFactory {
    private Type _rowObjectType = null;

    private BlancoDbSetting _setting = null;

    private BlancoDbDatabaseConnectionSettingDef _jdbc = null;

    private TypeFactory _typeFactory = null;

    private TableGateway _gateway = null;

    private SqlGenerator _sqlGenerator = null;

    public TableGatewayMethodFactory(TableGateway gateway) {
        _gateway = gateway;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();
        _setting = storage.getSetting();
        _jdbc = _setting.getJdbc();

        _rowObjectType = _typeFactory.createRowObject(_gateway.getClassName()
                + "Row");
        _sqlGenerator = createSqlGenerator();
    }

    public SqlGenerator createSqlGenerator() {
        SqlGeneratorFactory factory = createSqlGeneratorFactory();
        return factory.create(_jdbc, _rowObjectType, _gateway);
    }

    private SqlGeneratorFactory createSqlGeneratorFactory() {
        SqlGeneratorFactory result = null;
        GenerationProperties pro = new GenerationProperties();

        String factoryName = pro.getSqlGeneratorFactory();
        try {
            result = (SqlGeneratorFactory) Class.forName(factoryName)
                    .newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            result = new SqlGeneratorFactory();
        }
        return result;
    }

    public MethodExpander createUpdate() {
        String query = _sqlGenerator.getUpdate();
        UpdateMethod result = new UpdateMethod(_rowObjectType, _gateway, query);
        return result;
    }

    public MethodExpander createInsert() {
        String query = _sqlGenerator.getInsert();
        InsertMethod result = new InsertMethod(_gateway, query);
        return result;
    }

    public MethodExpander createSelect() {
        String query = _sqlGenerator.getSelect();
        SelectMethod result = new SelectMethod(_rowObjectType, _gateway, query);
        return result;
    }

    public MethodExpander createSelectAll() {
        String query = _sqlGenerator.getSelectAll();
        MethodExpander result = new SelectAllMethod(_rowObjectType, _gateway,
                query);
        return result;
    }

    public MethodExpander createDelete() {
        String query = _sqlGenerator.getDelete();
        DeleteMethod result = new DeleteMethod(_gateway, query);
        return result;
    }

    public MethodExpander createOutLog() {
        return new OutLogMethod();
    }

    public MethodExpander createPrintConsole() {
        return new PrintConsoleMethod();
    }
}