/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.row;

import java.util.Iterator;

import blanco.core.datastruct.DataStructClass;
import blanco.db.definition.AbstractField;
import blanco.db.definition.QueryIterator;
import blanco.db.definition.TableGateway;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * 
 * 
 * @author Tosiki Iga
 */
public class RowObjectClass extends DataStructClass {
    private GenerationProperties _properties = null;

    public RowObjectClass(Type type, TableGateway gateway) {
        super(type);
        setupSignature();
        setupFieldsClass(gateway.getFieldIterator());
    }

    public RowObjectClass(Type type, QueryIterator iteraotr) {
        super(type);
        setupSignature();
        setupFieldsClass(iteraotr.getFieldIterator());
    }

    public void setupSignature() {
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();
        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc()
                    .addLine("'" + getType().getName() + "'s\sNXB<br>");
        }
    }

    public void setupFieldsClass(Iterator fieldIterator) {
        Value value = null;
        AbstractField field = null;
        Type fieldType = null;

        getJavaDoc().addLine("<ul>");
        while (fieldIterator.hasNext()) {
            field = (AbstractField) fieldIterator.next();

            fieldType = field.getJavaType();
            if (fieldType.equals("java.sql.Date")) {
                fieldType = new Type("java.util.Date");
            }

            if (_properties.isGenerateJavaDoc()) {
                getJavaDoc().addLine(
                        "  <li>'" + field.getName() + "' ^:"
                                + field.getJavaType().getName());
            }

            value = new Value(fieldType, field.getName());
            addValue(value);
        }
        getJavaDoc().addLine("</ul>");
    }
}