/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.generator;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class TypeFactory {
    private String _nameSpace = "";

    private NameAdjuster _nameAdjuster = new NameAdjuster();

    public TypeFactory(String systemNameSpace) {
        _nameSpace = systemNameSpace;
    }

    public TypeFactory(String systemNameSpace, String middleNameSpace) {
        _nameSpace = systemNameSpace + "." + middleNameSpace;
    }

    private String getNameSpace() {
        return _nameSpace;
    }

    private String getNameSpace(String lastName) {
        StringBuffer sb = new StringBuffer(getNameSpace());
        sb.append(".");
        sb.append(lastName);
        return sb.toString();
    }

    public Type createRowObject(String baseName) {
        String name = _nameAdjuster.toClassName(baseName);
        return new Type(getNameSpace("row"), name);
    }

    public Type createTableGateway(String baseName) {
        String name = _nameAdjuster.toClassName(baseName + "Gateway");
        return new Type(getNameSpace("table.gateway"), name);
    }

    public Type createQueryIterator(String baseName) {
        String name = _nameAdjuster.toClassName(baseName + "Iterator");
        return new Type(getNameSpace("query"), name);
    }

    public Type createQueryInvoker(String baseName) {
        String name = _nameAdjuster.toClassName(baseName + "Invoker");
        return new Type(getNameSpace("query"), name);
    }

    public Type createRuntime(Class type) {
        String typeName = type.getName()
                .replaceAll("blanco.db", getNameSpace());
        return new Type(typeName);
    }

}