/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.properties;

import java.io.InputStream;
import java.util.Properties;

import blanco.db.expander.table.gateway.sql.SqlGeneratorFactory;

/**
 * @author Yasuo Nakanishi
 */
public class GenerationProperties {
    private String _sqlGeneratorFactory = SqlGeneratorFactory.class.getName();

    private boolean _generateJavaDoc = false;

    private Properties _properties = new Properties();

    public GenerationProperties() {
        load();
        setupValues();
    }

    private void load() {
        InputStream stream = null;
        try {
            stream = ClassLoader
                    .getSystemResourceAsStream("blancodb-generation.properties");
            if (stream != null) {
                _properties.load(stream);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setupValues() {
        String key = "";

        key = "blanco.db.sql.generator.factory";
        _sqlGeneratorFactory = _properties.getProperty(key,
                _sqlGeneratorFactory);

        // 2005.08.25 IGA Tosiki : JavaDoc ftHgtruełׂłB
        key = "blanco.db.generate.javadoc";
        _generateJavaDoc = new Boolean(_properties.getProperty(key, "true"))
                .booleanValue();
    }

    public String getSqlGeneratorFactory() {
        return _sqlGeneratorFactory;
    }

    public boolean isGenerateJavaDoc() {
        return _generateJavaDoc;
    }
}