/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.ig.service.ServiceClass;
import blanco.ig.tool.BaseObjectStorage;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbObjectStorage extends BaseObjectStorage {

    private static BlancoDbObjectStorage _instance = null;

    private BlancoDbObjectStorage(ServiceClass serviceClass) {
        super(serviceClass);
    }

    public static void initialize(ServiceClass serviceClass) {
        _instance = new BlancoDbObjectStorage(serviceClass);
    }

    public static BlancoDbObjectStorage getInstance() {
        //assert _instance != null;
        return _instance;
    }

    public GenerationProperties getGenerationProperties() {
        return (GenerationProperties) get("GenerationProperties");
    }

    public BlancoDbSetting getSetting() {
        return (BlancoDbSetting) get("Setting");
    }

    public TypeFactory getTypeFactory() {
        return (TypeFactory) get("TypeFactory");
    }
}