/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * blancoDbpQueryp[XE[eBeBNX <br>
 * SQL̉߂ѕϊȂǂړIƂ܂B <br>
 * 
 * @author Tosiki Iga
 */
public class BlancoDbQueryParserUtil {
    /**
     * SQL̓p[^ƂĔ肷邽߂̐K\B
     */
    private static final String SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER = "#[a-zA-Z0-9.\\-_\\P{InBasicLatin}]*\\b|#.*$";

    /**
     * SQL̓p[^̃}bv <br>
     * TODO }bv̓}YCłB
     */
    private Map _mapForSqlInputParameters = new Hashtable();

    /**
     * IWiSQL
     */
    private String _originalSqlQueryString = "";

    public BlancoDbQueryParserUtil(String sqlQueryString) {
        // p[^L܂B
        _originalSqlQueryString = sqlQueryString;

        // K\CX^X𐶐܂B
        // TODO K\ɂ鏈͕sK؁B
        Matcher matcher = Pattern.compile(SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER)
                .matcher(_originalSqlQueryString);

        for (int index = 1; matcher.find(); index++) {
            String name = matcher.group();
            // 擪́܂B
            name = name.substring(1, name.length());
            if (_mapForSqlInputParameters.containsKey(name) == false) {
                _mapForSqlInputParameters.put(name, new ArrayList());
            }
            ((ArrayList) _mapForSqlInputParameters.get(name)).add(new Integer(
                    index));
        }

        for (Iterator ite = _mapForSqlInputParameters.keySet().iterator(); ite
                .hasNext();) {
            String key = (String) ite.next();
            List list = (List) _mapForSqlInputParameters.get(key);
            _mapForSqlInputParameters.put(key, convertListToArray(list));
        }
    }

    /**
     * ͂ꂽSQL̓p[^intzɕϊ܂B
     * 
     * @param sqlInputParameterFoundList
     * @return
     */
    private int[] convertListToArray(List sqlInputParameterFoundList) {
        int[] convertedIntArray = new int[sqlInputParameterFoundList.size()];
        Iterator ite = sqlInputParameterFoundList.iterator();
        for (int index = 0; ite.hasNext(); index++) {
            convertedIntArray[index] = ((Integer) ite.next()).intValue();
        }
        return convertedIntArray;
    }

    /**
     * IteratorɎۂɒ荞܂i`SQL
     * 
     * @return
     */
    public String getNaturalSqlString() {
        return _originalSqlQueryString.replaceAll(
                SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER, "?");
    }

    /**
     * FL[ɁAintQbg܂B
     * 
     * @param key
     * @return
     */
    public int[] getSqlInputParameters(String key) {
        // TODO }bvIteratorNĂ̂B
        return (int[]) _mapForSqlInputParameters.get(key);
    }
}