/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import java.sql.SQLException;

import blanco.db.exception.IntegrityConstraintException;

/**
 * blancoDbp郆[eBeBNX <br>
 * NXԂŋʉėp鏈ɋLڂ܂B <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @author Tosiki Iga
 */
public class BlancoDbUtil {

    public final static boolean isIntegrityConstraintException(
            SQLException originalException) {
        String sqlState = originalException.getSQLState();
        if (sqlState != null && sqlState.startsWith("23")) {
            return true;
        }
        return false;
    }

    public final static void throwIntegrityConstraintException(
            SQLException originalException)
            throws IntegrityConstraintException {
        IntegrityConstraintException ex = new IntegrityConstraintException(
                "ᔽɂύXɎs܂B:" + originalException.toString(),
                originalException.getSQLState(), originalException
                        .getErrorCode());
        ex.initCause(originalException);
        throw ex;
    }

    /**
     * TimestampDateɕϊ܂
     * 
     * @param aTimestamp
     * @return
     */
    public final static java.util.Date convertTimestampToDate(
            java.sql.Timestamp aTimestamp) {
        if (aTimestamp == null) {
            return null;
        }
        return new java.util.Date(aTimestamp.getTime());
    }
}