/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.test;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.ImplementData;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Statement;

/**
 * @author Yasuo Nakanishi
 */
public class TestCaseImplementor extends Implementor{

    public TestCaseImplementor(ImplementData data) {
        super(data);
    }

    public void assertEquals(Statement expect, Statement value){
        Call c = new Call("assertEquals");
        c.addArgument(expect);
        c.addArgument(value);
        addStatement(c);
    }

    public void assertEquals(Statement expect, Statement value, Statement delta){
        Call c = new Call("assertEquals");
        c.addArgument(expect);
        c.addArgument(value);
        c.addArgument(delta);
        addStatement(c);
    }

    public void assertTrue(Statement statement){
        Call c = new Call("assertTrue");
        c.addArgument(statement);
        addStatement(c);
    }

    public void assertException(Statement statement, Type exceptionType){
        Call c = null;
        openTry();
        addStatement(statement);
        addStatement(new Call("fail"));
        addCatch(new Value(exceptionType, "e"));
        c = new Call("assertTrue");
        c.addArgument(new Statement(boolean.class, "true"));
        addStatement(c);
        closeTry();
    }
}
