/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

/**
 * @author Yasuo Nakanishi
 */
public class Value {
	private Type _type = null;
	private String _name = "";
	
	public static final Value NULL = new Value(Object.class, "null");

	public Value(Class type, String name){
		this(new Type(type), name);
	}

	public Value(Type type, String name){
		_type = type;
		_name = name;
	}
	
	public String getName() {
		return _name;
	}

	public Type getType() {
		return _type;
	}
}
