/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import blanco.db.alias.NameTranslator;
import blanco.ig.generator.GeneratorSetting;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbSetting extends GeneratorSetting {
    private boolean _isOldVersionSupportForTableGateway = false;

    private boolean _enableAliasPool = true;

    private NameTranslator _translator = null;

    private String _queryDirectory = ".";

    private BlancoDbDatabaseConnectionSettingDef _jdbc = null;

    private Logging _logging = Logging.NONE;

    public BlancoDbSetting() {
    }

    /**
     * ȑÕo[WŃT|[gĂTableGateway쐬邩ǂH
     * 
     * @param arg
     */
    public void setSupportOldVersionTableGateway(boolean arg) {
        _isOldVersionSupportForTableGateway = arg;
    }

    public boolean isSupportOldVersionTableGateway() {
        return _isOldVersionSupportForTableGateway;
    }

    public BlancoDbDatabaseConnectionSettingDef getJdbc() {
        return _jdbc;
    }

    public void setJdbc(BlancoDbDatabaseConnectionSettingDef jdbc) {
        _jdbc = jdbc;
    }

    public boolean isEnableAliasPool() {
        return _enableAliasPool;
    }

    public void setEnableAliasPool(boolean enable) {
        _enableAliasPool = enable;
    }

    public boolean isEnableNameTranslator() {
        return _translator != null;
    }

    public NameTranslator getNameTranslator() {
        return _translator;
    }

    public void setNameTranslator(NameTranslator translator) {
        _translator = translator;
    }

    public void setQueryDirectory(String queryDirectory) {
        _queryDirectory = queryDirectory;
    }

    public String getQueryDirectory() {
        return _queryDirectory;
    }

    public boolean isEnabledLogging() {
        boolean result = false;
        if (_logging != Logging.NONE) {
            result = true;
        }
        return result;
    }

    public Logging getLogging() {
        return _logging;
    }

    public void setLogging(Logging logging) {
        _logging = logging;
    }
}