/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.math.BigDecimal;
import java.util.Date;

import blanco.ig.expander.Type;

/**
 * @author t.iga
 * @author Yasuo Nakanishi
 */
public class TableField extends AbstractField {
    private boolean _primaryKey = false;

    private short _primaryKeySequence = 0;

    public TableField(Type type, String columnName) {
        super(type, columnName);
    }

    public TableField(Class type, String columnName) {
        super(type, columnName);
    }

    public void setPrimaryKeySeq(short sequence) {
        _primaryKey = true;
        _primaryKeySequence = sequence;
    }

    public short getPrimaryKeySeq() {
        //assert isPrimaryKey() : "Is not primary key.";
        return _primaryKeySequence;
    }

    public boolean isPrimaryKey() {
        return _primaryKey;
    }

    public boolean isString() {
        boolean result = false;
        if (getJavaType().getFullName().equals(String.class.getName())) {
            result = true;
        }
        return result;
    }

    public boolean isShort() {
        boolean result = false;
        if (getJavaType().getFullName().equals(short.class.getName())) {
            result = true;
        }
        return result;
    }

    public boolean isInt() {
        boolean result = false;
        if (getJavaType().getFullName().equals(int.class.getName())) {
            result = true;
        }
        return result;
    }

    public boolean isBigDecimal() {
        boolean result = false;
        if (getJavaType().getFullName().equals(BigDecimal.class.getName())) {
            result = true;
        }
        return result;
    }

    public boolean isDate() {
        boolean result = false;
        if (getJavaType().getFullName().equals(Date.class.getName())) {
            result = true;
        }
        return result;
    }

    public boolean isBoolean() {
        boolean result = false;
        if (getJavaType().getFullName().equals(boolean.class.getName())) {
            result = true;
        }
        return result;
    }
}