/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

import java.sql.SQLException;

/**
 * f[^x[XᔽɊւONX <br>
 * ̃NXblancoDb\[XR[hŗp܂ <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @since 2005.05.12
 * @author Tosiki Iga
 */
public class IntegrityConstraintException extends SQLException {
    private static final String SQLSTATE_INTEGRITYCONSTRAINT = "23000";

    /**
     * ᔽƂOIuWFNg ̃CX^X쐬܂B
     * 
     * @deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB
     */
    public IntegrityConstraintException() {
        super("Integrity consrtraint exception has occured.",
                SQLSTATE_INTEGRITYCONSTRAINT);
    }

    /**
     * ᔽƂOIuWFNg ̃CX^X쐬܂B
     * 
     * @deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB
     * @param reason
     */
    public IntegrityConstraintException(String reason) {
        super(reason, SQLSTATE_INTEGRITYCONSTRAINT);
    }

    /**
     * ᔽƂOIuWFNg ̃CX^X쐬܂B
     * 
     * @deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB
     * @param reason
     * @param SQLState
     */
    public IntegrityConstraintException(String reason, String SQLState) {
        super(reason, SQLState);
    }

    /**
     * ᔽƂOIuWFNg ̃CX^X쐬܂B
     * 
     * @param reason
     * @param SQLState
     * @param vendorCode
     */
    public IntegrityConstraintException(String reason, String SQLState,
            int vendorCode) {
        super(reason, SQLState, vendorCode);
    }
}