/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

import java.sql.SQLException;

/**
 * f[^x[X̏1sł͂ȂƂONX <br>
 * ̃NXblancoDb\[XR[hŗp܂ <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @since 2005.05.12
 * @author Tosiki Iga
 */
public class NotSingleRowException extends SQLException {

    /**
     * SQLState͉̒lƂĐݒ肵Ă܂B <br>
     * vO SQLStateɗ炸 ONXɂĔf悤ɂĂB
     */
    private static final String SQLSTATE_NOTSINGLEROW = "00101";

    /**
     * ҂Psł͖ƂOIuWFNg ̃CX^X쐬܂B <br>
     * 
     * @deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B
     */
    public NotSingleRowException() {
        super("Not single row exception has occured.", SQLSTATE_NOTSINGLEROW);
    }

    /**
     * ҂Psł͖ƂOIuWFNg ̃CX^X쐬܂B <br>
     * 
     * @param reason
     */
    public NotSingleRowException(String reason) {
        super(reason, SQLSTATE_NOTSINGLEROW);
    }

    /**
     * ҂Psł͖ƂOIuWFNg ̃CX^X쐬܂B <br>
     * 
     * @param reason
     * @param SQLState
     */
    public NotSingleRowException(String reason, String SQLState) {
        super(reason, SQLState);
    }

    /**
     * ҂Psł͖ƂOIuWFNg ̃CX^X쐬܂B <br>
     * 
     * @param reason
     * @param SQLState
     * @param vendorCode
     */
    public NotSingleRowException(String reason, String SQLState, int vendorCode) {
        super(reason, SQLState, vendorCode);
    }
}