/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.log;

import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class OutLogMethod extends MethodExpander {
    private Value _messageArgument = null;

    public OutLogMethod() {
        super("outLog");
    }

    public void setupSignature() {
        setScope(Scope.PROTECTED);

        Value message = new Value(String.class, "message");
        _messageArgument = message;
        addArgument(message);
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        Value logger = getField("Logger");

        Receiver r = new Receiver(logger);
        Call c = r.call("info");
        c.addArgument(_messageArgument);

        implementor.addStatement(r);
    }

}