/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.log;

import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class PrintConsoleMethod extends MethodExpander {
    private Value _nameArgument = null;

    private Value _messageArgument = null;

    private GenerationProperties _properties = null;

    public PrintConsoleMethod() {
        super("printConsole");

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _properties = storage.getGenerationProperties();
    }

    public void setupSignature() {
        setScope(Scope.PROTECTED);

        Value name = new Value(String.class, "name");
        _nameArgument = name;
        addArgument(name);

        Value message = new Value(String.class, "message");
        _messageArgument = message;
        addArgument(message);
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        Receiver r = new Receiver(System.class, "out");
        Call c = r.call("print");
        c.addArgument(new StringLiteral("Name:"));
        implementor.addStatement(r);

        r = new Receiver(System.class, "out");
        c = r.call("println");
        c.addArgument(_nameArgument);
        implementor.addStatement(r);

        r = new Receiver(System.class, "out");
        c = r.call("println");
        c.addArgument(_messageArgument);
        implementor.addStatement(r);

        if (_properties.isGenerateJavaDoc()) {
            String message = "R\[֏óB";
            getJavaDoc().addLine(message);

            message = "NGB";
            getJavaDoc().addParameter(_nameArgument.getName(), message);
            message = "bZ[WB";
            getJavaDoc().addParameter(_messageArgument.getName(), message);
        }
    }
}