/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.Connection;

import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.Constructor;

/**
 * @author Yasuo Nakanishi
 */
public class QueryConstructor extends Constructor {
    private Value _connectinonArgument = new Value(Connection.class,
            "connection");

    private GenerationProperties _properties = null;

    public QueryConstructor(Type type) {
        super(type);
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();
    }

    public void setupSignature() {
        addArgument(_connectinonArgument);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine(getName() + "NX̃RXgN^łB");
            getJavaDoc().addParameter(_connectinonArgument.getName(),
                    "f[^x[Xڑ");
        }
    }

    public void implement() {
        Implementor i = new Implementor(getData());

        Value connectionField = new Value(Connection.class, "_connection");
        i.assign(connectionField, _connectinonArgument);
    }
}