/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.sql.SQLException;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.QueryInvoker;
import blanco.db.exception.IntegrityConstraintException;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteUpdateMethod extends MethodExpander {
    private Value _statement = null;

    private TypeFactory _typeFactory = null;

    private BlancoDbSetting _setting = null;

    private QueryInvoker _invoker = null;

    private GenerationProperties _properties = null;

    public ExecuteUpdateMethod(QueryInvoker invoker) {
        super("executeUpdate");

        _invoker = invoker;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _setting = storage.getSetting();
        _typeFactory = storage.getTypeFactory();
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();

    }

    public void setupSignature() {
        Type resultType = new Type(int.class);
        setReturnType(resultType);

        Type integrityConstraintException = new Type(_setting
                .getRootNameSpace()
                + ".exception.IntegrityConstraintException");
        addException(integrityConstraintException);
        addUsingType(integrityConstraintException);

        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("s^NGs܂B<br>");
            getJavaDoc()
                    .addLine(
                            "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B<br>");
            getJavaDoc().addReturn("ꂽs");
        }
    }

    public void implement() {
        BlancoDbImplementor i = new BlancoDbImplementor(getData());

        // statementmۂł΂AIprepareStatementĂяo܂B
        i.addLine("if (_statement == null) {");
        i.addStatement("prepareStatement()");
        i.addLine("}");

        if (_setting.isEnabledLogging()) {
            i.outLog(_statement);
        }

        i.emptyLine();

        i.openTry();
        i.addStatement("return _statement.executeUpdate()");

        Value e = new Value(SQLException.class, "e");
        i.addCatch(e);

        Type exceptionType = _typeFactory
                .createRuntime(IntegrityConstraintException.class);
        i.throwIntegrityConstraintException(e, exceptionType);

        i.closeTry();
    }
}