/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;
import java.sql.SQLException;

import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class CloseMethod extends MethodExpander {
    private Value _resultSet = null;

    private Value _statement = null;

    private GenerationProperties _properties = null;

    public CloseMethod() {
        super("close");
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();
    }

    public void setupSignature() {
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("pĂJDBC\[X܂B<br>");
            getJavaDoc().addLine("NX̗pIۂɕK̃\bhĂяoĂB");
        }
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        String name = getNameAdjuster().toFieldName("ResultSet");
        _resultSet = new Value(ResultSet.class, name);
        _statement = getField("Statement");

        implementor.closeResultSetAndStatement(_resultSet, _statement);
    }

}