/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;
import java.sql.SQLException;

import blanco.db.definition.QueryIterator;
import blanco.db.exception.NoRowFoundException;
import blanco.db.exception.TooManyRowsFoundException;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class GetAsObjectMethod extends MethodExpander {
    private Value _result = null;

    private TypeFactory _typeFactory = null;

    private QueryIterator _iterator = null;

    private Value _resultSet = null;

    private GenerationProperties _properties = null;

    public GetAsObjectMethod(Type rowObjectType, QueryIterator iterator) {
        super(MethodExpander.createName("get", "AsObject"));

        _iterator = iterator;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();
        _properties = storage.getGenerationProperties();

        _resultSet = new Value(ResultSet.class, "_resultSet");
        _result = new Value(rowObjectType, "result");
    }

    public void setupSignature() {
        setReturnType(_result.getType());
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B");
            if (_iterator.isSingle()) {
                getJavaDoc().addLine("");
                getJavaDoc().addLine("singleL<br>");
                getJavaDoc()
                        .addLine("ʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
                getJavaDoc().addLine("hNX̗O܂B");
            }
            getJavaDoc().addLine(
                    "@deprecated  getRowgetSingleRow𗘗pĂB");
            getJavaDoc().addReturn("sIuWFNg");
        }
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        if (_iterator.isSingle()) {
            Type exceptionType = _typeFactory
                    .createRuntime(NoRowFoundException.class);
            implementor.checkRowNotFound(_resultSet, exceptionType);
            implementor.emptyLine();
        }

        implementor.declare(_result, new Call(_result.getType()));
        implementor.addStatement("result = getRow()");

        if (_iterator.isSingle()) {
            implementor.emptyLine();

            Type exeptionType = _typeFactory
                    .createRuntime(TooManyRowsFoundException.class);
            implementor.checkTooManyRowsFound(_resultSet, exeptionType);
        }

        implementor.emptyLine();

        implementor.addReturn(_result);
    }
}