/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetResultSetMethod extends MethodExpander {
    private Value _result = null;

    private TypeFactory _typeFactory = null;

    private BlancoDbSetting _setting = null;

    private Value _resultSet = null;

    private GenerationProperties _properties = null;

    public GetResultSetMethod() {
        super("getResultSet");

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();
        _properties = storage.getGenerationProperties();
        _setting = storage.getSetting();

        _resultSet = new Value(ResultSet.class, "_resultSet");
    }

    public void setupSignature() {
        setReturnType(_resultSet.getType());

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("ResultSet擾܂B");
            getJavaDoc().addLine("@deprecated {IResultSet𒼐ڗpKv͂܂B");
            getJavaDoc().addReturn("ResultSetIuWFNg");
        }
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        implementor.addReturn(_resultSet);
    }
}