/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

import blanco.core.datastruct.WriteAccessor;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.QueryField;
import blanco.db.definition.QueryIterator;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetRowMethod extends MethodExpander {
    private Value _result = null;

    private TypeFactory _typeFactory = null;

    private QueryIterator _iterator = null;

    private BlancoDbSetting _setting = null;

    private Value _resultSet = null;

    private GenerationProperties _properties = null;

    public GetRowMethod(Type rowObjectType, QueryIterator iterator) {
        super("getRow");

        _iterator = iterator;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();
        _properties = storage.getGenerationProperties();
        _setting = storage.getSetting();

        _resultSet = new Value(ResultSet.class, "_resultSet");
        _result = new Value(rowObjectType, "result");
    }

    public void setupSignature() {
        setReturnType(_result.getType());
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B");
            getJavaDoc().addReturn("sIuWFNg");
        }
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        implementor.declare(_result, new Call(_result.getType()));
        Iterator fieldIterator = _iterator.getFieldIterator();
        QueryField field = null;

        int indexCol = 1;
        while (fieldIterator.hasNext()) {
            field = (QueryField) fieldIterator.next();

            if (field.getTypeName().equals("Date")) {
                implementor.addUsingType(new Type(_setting.getRootNameSpace()
                        + ".util.BlancoDbUtil"));
            }

            implementor.addStatement("result."
                    + WriteAccessor.createName(field.getName())
                    + "("
                    + BlancoDbMappingUtil.mapWrapperClassForPrimitive(
                            "_resultSet."
                                    + BlancoDbMappingUtil
                                            .getResultSetGetterMethodName(field
                                                    .getTypeName()) + "("
                                    + indexCol + ")", field.getTypeName())
                    + ")");

            if (field.getObjectMappingForPrimitiveNullSupport()) {
                implementor.openIf("_resultSet.wasNull()");
                implementor.addStatement("result."
                        + getNameAdjuster().getMethodName("set",
                                field.getName()) + "(null)");
                implementor.closeIf();
            }
            indexCol++;
        }

        implementor.emptyLine();

        implementor.addReturn(_result);
    }
}