/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.ResultSet;
import java.sql.SQLException;

import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.QueryIterator;
import blanco.db.exception.NoRowFoundException;
import blanco.db.exception.TooManyRowsFoundException;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.db.generator.TypeFactory;
import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * Singletruȅꍇɂ̂݁ÃNX͗p܂
 * 
 * @author Tosiki Iga
 */
public class GetSingleRowMethod extends MethodExpander {
    private Value _result = null;

    private TypeFactory _typeFactory = null;

    private QueryIterator _iterator = null;

    private BlancoDbSetting _setting = null;

    private Value _resultSet = null;

    private GenerationProperties _properties = null;

    public GetSingleRowMethod(Type rowObjectType, QueryIterator iterator) {
        super("getSingleRow");

        _iterator = iterator;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();
        _properties = storage.getGenerationProperties();
        _setting = storage.getSetting();

        _resultSet = new Value(ResultSet.class, "_resultSet");
        _result = new Value(rowObjectType, "result");
    }

    public void setupSignature() {
        setReturnType(_result.getType());

        Type noRowFoundException = new Type(_setting.getRootNameSpace()
                + ".exception.NoRowFoundException");
        addException(noRowFoundException);
        addUsingType(noRowFoundException);
        Type tooManyRowsFoundException = new Type(_setting.getRootNameSpace()
                + ".exception.TooManyRowsFoundException");
        addException(tooManyRowsFoundException);
        addUsingType(tooManyRowsFoundException);

        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B");
            getJavaDoc().addLine("");
            getJavaDoc().addLine("singleL<br>");
            getJavaDoc().addLine("ʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
            getJavaDoc().addLine("hNX̗O܂B");
            getJavaDoc().addReturn("sIuWFNg");
        }
    }

    public void implement() {
        BlancoDbImplementor implementor = new BlancoDbImplementor(getData());

        Type exceptionType = _typeFactory
                .createRuntime(NoRowFoundException.class);
        implementor.checkRowNotFound(_resultSet, exceptionType);
        implementor.emptyLine();

        implementor.addStatement(_result.getType().getName()
                + " result = getRow()");
        implementor.emptyLine();

        Type exeptionType = _typeFactory
                .createRuntime(TooManyRowsFoundException.class);
        implementor.checkTooManyRowsFound(_resultSet, exeptionType);

        implementor.emptyLine();

        implementor.addReturn(_result);
    }
}