/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryField;
import blanco.db.definition.QueryIterator;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.PrepareStatementCursorMethod;
import blanco.db.expander.query.PrepareStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod2;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.generator.TypeFactory;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class QueryItratorMethodFactory {
    private Type _type = null;

    private QueryIterator _iterator = null;

    private TypeFactory _typeFactory = null;

    public QueryItratorMethodFactory(QueryIterator iterator) {
        _iterator = iterator;

        BlancoDbObjectStorage storage = BlancoDbObjectStorage.getInstance();
        _typeFactory = storage.getTypeFactory();

        _type = _typeFactory.createQueryIterator(_iterator.getName());
    }

    public MethodExpander createConstructor() {
        MethodExpander result = new QueryConstructor(_type);
        return result;
    }

    public MethodExpander createGetAsList() {
        return new GetAsListMethod(_iterator);
    }

    public MethodExpander createGetList() {
        return new GetListMethod(_iterator);
    }

    public MethodExpander createNext() {
        return new NextMethod(_iterator);
    }

    public MethodExpander createPrevious() {
        return new PreviousMethod(_iterator);
    }

    public MethodExpander createFirst() {
        return new FirstMethod(_iterator);
    }

    public MethodExpander createLast() {
        return new LastMethod(_iterator);
    }

    public MethodExpander createAbsolute() {
        return new AbsoluteMethod(_iterator);
    }

    public MethodExpander createRelative() {
        return new RelativeMethod(_iterator);
    }

    protected MethodExpander createClose() {
        MethodExpander result = new CloseMethod();
        return result;
    }

    protected MethodExpander createPrepareStatement() {
        MethodExpander result = new PrepareStatementMethod();
        return result;
    }

    protected MethodExpander createPrepareStatement2() {
        MethodExpander result = new PrepareStatementMethod2(_iterator);
        return result;
    }

    protected MethodExpander createPrepareStatementCursor() {
        MethodExpander result = new PrepareStatementCursorMethod();
        return result;
    }

    protected MethodExpander createGetAsObject() {
        Type rowObjectType = _typeFactory.createRowObject(_iterator.getName()
                + "Row");
        MethodExpander result = new GetAsObjectMethod(rowObjectType, _iterator);
        return result;
    }

    protected MethodExpander createGetRow() {
        Type rowObjectType = _typeFactory.createRowObject(_iterator.getName()
                + "Row");
        MethodExpander result = new GetRowMethod(rowObjectType, _iterator);
        return result;
    }

    protected MethodExpander createGetSingleRow() {
        Type rowObjectType = _typeFactory.createRowObject(_iterator.getName()
                + "Row");
        MethodExpander result = new GetSingleRowMethod(rowObjectType, _iterator);
        return result;
    }

    protected MethodExpander createGetResultSet() {
        MethodExpander result = new GetResultSetMethod();
        return result;
    }

    protected MethodExpander createSetInputParameter() {
        MethodExpander result = new SetInputParameterMethod(_iterator);
        return result;
    }

    /**
     * eX̗ɑ΂update\bh𐶐܂B J[\[h̍ۂɂ̂ݗLłB
     */
    protected MethodExpander createUpdateObject(QueryField field) {
        MethodExpander result = new UpdateObjectMethod(_iterator, field);
        return result;
    }

    /**
     * J[\[h̍ۂɂ̂ݗLłB
     */
    protected MethodExpander createUpdateRow() {
        MethodExpander result = new UpdateRowMethod(_iterator);
        return result;
    }

    protected MethodExpander createExecuteQuery() {
        MethodExpander result = new ExecuteQueryMethod(_iterator);
        return result;
    }

    public MethodExpander createGetQuery(String query) {
        return new GetQueryMethod(query);
    }
}