/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway;

import java.sql.Connection;

import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.Constructor;

/**
 * @author Yasuo Nakanishi
 */
public class TableGatewayConstructor extends Constructor {
    private Value connection = new Value(Connection.class, "connection");

    private GenerationProperties _properties = null;

    public TableGatewayConstructor(String type) {
        super(type);

        addArgument(connection);

        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine(getName() + "NX̃RXgN^łB");

            String name = connection.getName();
            getJavaDoc().addParameter(name, "f[^x[Xڑ");
        }
    }

    public void implement() {
        Implementor implementor = new Implementor(getData());

        Value fieldConnecton = new Value(Connection.class, "_connection");
        implementor.assign(fieldConnecton, connection);
    }
}