/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway;

import blanco.db.definition.TableField;
import blanco.db.definition.TableGateway;
import blanco.db.expander.implementor.BlancoDbImplementor;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public abstract class TableGatewayMethod extends MethodExpander {
    private TableGateway _gateway = null;

    private BlancoDbImplementor _implementor = null;

    public TableGatewayMethod(String name, TableGateway gateway) {
        super(name);
        //assert gateway != null;
        _gateway = gateway;

        _implementor = new BlancoDbImplementor(getData());
    }

    protected BlancoDbImplementor getImplementor() {
        return _implementor;
    }

    protected Value createPrimaryKeyArgument(TableField field) {
        String name = getNameAdjuster().toValueName(field.getName());
        return new Value(field.getJavaType(), name);
    }

    protected TableGateway getGateway() {
        return _gateway;
    }

}