/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.table.gateway.sql;

import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.definition.TableGateway;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class SqlGeneratorFactory {

    /**
     * SqlGeneratorIuWFNg쐬܂B <br>
     * [blancoDb̃\[XR[h{ĂlցB]̃\bh ڑȑOɌĂяôJDBC^񂪗płȂ_ɒӂB
     * 
     * @param jdbc
     * @param option
     * @param rowType
     * @param gateway
     * @return
     */
    public SqlGenerator create(BlancoDbDatabaseConnectionSettingDef jdbc,
            Type rowType, TableGateway gateway) {
        SqlGenerator result = null;
        String driver = jdbc.getJdbcDriver();
        if (driver.equals("org.hsqldb.jdbcDriver")) {
            result = new HSqlDbSqlGenerator(rowType, gateway);
        } else if (driver
                .equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            result = new SqlServerSqlGenerator(rowType, gateway);
        } else if (driver.equals("org.postgresql.Driver")) {
            result = new PostgreSqlSqlGenerator(rowType, gateway);
        } else if (driver.equals("oracle.jdbc.driver.OracleDriver")) {
            result = new OracleSqlGenerator(rowType, gateway);
        } else {
            // m̃hCołBftHgNXőΉ܂B
            result = new DefaultSqlGenerator(rowType, gateway);
        }
        return result;
    }
}