/**
 * blancoDb-Excel2Xml <br>
 * blancoDb-helperc[: ExcelV[gǂݍblancoDbp̒`XMLt@C 邽߂̃[eBeBvO
 * <br>
 * 
 * @author Tosiki Iga
 */

package blanco.db.helper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

import blanco.commons.calc.parser.BlancoCalcParser;
import blanco.commons.calc.parser.block.BlancoCalcParserPropertyBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserPropertyKey;
import blanco.commons.calc.parser.block.BlancoCalcParserTableBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserTableColumn;
import blanco.commons.calc.parser.block.BlancoCalcParserValueMapping;
import blanco.db.BlancoDbConstants;

public abstract class BlancoDbExcel2Xml implements IBlancoDbProgress {
    private static final boolean IS_DEBUG = false;

    /**
     * ̓fBNg
     */
    private File inDirectory = null;

    /**
     * o̓fBNg
     */
    private File outDirectory = null;

    private BlancoDbExcel2Xml() {
    }

    /**
     * ftHgł́A̓fBNg[sql/excel] o̓fBNg[sql/blanco] ŏ{܂B
     * 
     * @param args
     */
    public static final void main(String[] args) {
        new BlancoDbExcel2Xml(new File("sql/sql2k"), new File("sql/sql2k")) {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                return true;
            }
        }.processAllFiles();
    }

    /**
     * ̓fBNgAo̓fBNgwsȂCX^X𐶐܂B
     * 
     * @param inDirectory
     *            ̓fBNg
     * @param outDirectory
     *            o̓fBNg
     */
    public BlancoDbExcel2Xml(File inDirectory, File outDirectory) {
        this.inDirectory = inDirectory;
        this.outDirectory = outDirectory;
    }

    /**
     * ̓fBNgɂ邷ׂĂxlst@C܂
     */
    public void processAllFiles() {
        System.out.println(BlancoDbConstants.PRODUCT_NAME + " ("
                + BlancoDbConstants.VERSION + ") SQLݒt@CXMLԃt@Cɕϊ: Jn.");

        if (outDirectory.exists() == false) {
            outDirectory.mkdirs();
        }
        File[] files = inDirectory.listFiles();
        if (files == null) {
            System.out.println("tH_[" + inDirectory.getAbsolutePath()
                    + "]ɂ1t@C܂ł.");
            return;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].getName().endsWith(".xls")) {
                if (progress(index + 1, files.length, files[index].getName()) == false) {
                    break;
                }

                process(files[index]);
            }
        }
        System.out.println("SQLݒt@CXMLԃt@Cɕϊ: I.");
    }

    /**
     * wExcelݒt@C܂B
     * 
     * @param blancoDbSettingFile
     */
    public void process(File blancoDbSettingFile) {
        System.out
                .println("blancoDb̐ݒt@C ["
                        + blancoDbSettingFile.getAbsolutePath()
                        + "] (ExcelubN)܂.");

        // try {
        // workbook = Workbook.getWorkbook(blancoDbSettingFile);
        // } catch (BiffException ex) {
        // System.err.println("\ʗO.wExcelubNǍɎs܂.f[^`sł.:"
        // + ex.toString());
        // return;
        // } catch (IOException ex) {
        // System.err.println("\ʗO.wExcelubNǍɎs܂.:" + ex.toString());
        // return;
        // }

        BlancoCalcParserPropertyBlock blockItem = new BlancoCalcParserPropertyBlock(
                "attribute");
        blockItem.setStartString(new String[] { "Ɩ", "̈" });
        blockItem
                .setValueMapping(new BlancoCalcParserValueMapping[] {
                        new BlancoCalcParserValueMapping(new String[] { "",
                                "" }, "true"),
                        new BlancoCalcParserValueMapping(new String[] { "Ȃ" },
                                "false"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "^" }, "iterator"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "s^" }, "invoker"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "KP" }, "true"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "(0܂)" }, "false"),
                        new BlancoCalcParserValueMapping(new String[] {
                                "FORWARD_ONLY", "Ȃ" }, "forward_only"),
                        new BlancoCalcParserValueMapping(new String[] {
                                "INSENSITIVE", "" }, "insensitive"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "SENSITIVE" }, "sensitive") });

        BlancoCalcParserPropertyKey item = new BlancoCalcParserPropertyKey(
                "gamen-id", new String[] { "ID" });
        item.setSearchRangeX(4);
        blockItem.add(item);

        item = new BlancoCalcParserPropertyKey("name", new String[] { "NG" });
        item.setSearchRangeX(4);
        blockItem.add(item);

        item = new BlancoCalcParserPropertyKey("query-type",
                new String[] { "SQL^Cv" });
        item.setSearchRangeX(8);
        blockItem.add(item);

        item = new BlancoCalcParserPropertyKey("single",
                new String[] { "҂鏈" });
        item.setSearchRangeX(8);
        blockItem.add(item);

        item = new BlancoCalcParserPropertyKey("scroll", new String[] {
                "XN[", "J[\" });
        item.setSearchRangeX(8);
        blockItem.add(item);

        item = new BlancoCalcParserPropertyKey("updatable",
                new String[] { "XV\" });
        item.setSearchRangeX(8);
        blockItem.add(item);

        BlancoCalcParser parser = new BlancoCalcParser();
        parser.add(blockItem);

        // ʂ̃ubN
        BlancoCalcParserTableBlock iteblockItem = new BlancoCalcParserTableBlock(
                "parameters");
        iteblockItem.setStartString(new String[] { "SQL̓p[^", "p[^`" });
        iteblockItem.setSearchRangeForTitleY(2);
        iteblockItem.setRowName("parameter");

        BlancoCalcParserTableColumn iteitem = new BlancoCalcParserTableColumn(
                "name", new String[] { "p[^ID" });
        iteblockItem.add(iteitem);

        iteitem = new BlancoCalcParserTableColumn("type",
                new String[] { "^Cv" });
        iteblockItem.add(iteitem);

        iteitem = new BlancoCalcParserTableColumn("p[^",
                new String[] { "p[^" });
        iteblockItem.add(iteitem);

        parser.add(iteblockItem);

        // ʂ̃ubN
        iteblockItem = new BlancoCalcParserTableBlock("query");
        iteblockItem.setStartString(new String[] { "SQL" });
        iteblockItem.setEndString(new String[] { "SQLGAI" });
        iteblockItem.setSearchRangeForTitleY(1);
        iteblockItem.setSearchRangeY(100);
        iteitem = new BlancoCalcParserTableColumn("query-line",
                new String[] { "SQL" });
        iteblockItem.add(iteitem);
        parser.add(iteblockItem);

        SAXSource source = new SAXSource(parser, new InputSource(
                blancoDbSettingFile.getAbsolutePath()));

        // parser.chainContentHandlerStream(new BlancoDbExcelContentHandler(
        // new SystemOutContentHandler()));
        parser.chainContentHandlerStream(new BlancoDbExcelContentHandler());

        OutputStream outStream = null;
        try {
            // [gm[hwB
            parser.setProperty(BlancoCalcParser.URI_PROPERTY_NAME_WORKBOOK,
                    "blanco-db");
            outStream = new BufferedOutputStream(new FileOutputStream(
                    outDirectory.getAbsolutePath()
                            + "/"
                            + blancoDbSettingFile.getName().replaceAll(".xls",
                                    ".xml")));
            BlancoCalcParser.getTransformer().transform(source,
                    new StreamResult(outStream));
            outStream.flush();
            outStream.close();
            outStream = null;
        } catch (TransformerException ex) {
            System.out.println("XMLhLgۑɕϊO܂.:" + ex.toString());
            ex.printStackTrace();
            return;
        } catch (IOException ex3) {
            System.out.println("XMLhLgۑɓo͗O܂.:" + ex3.toString());
            ex3.printStackTrace();
            return;
        } catch (SAXNotRecognizedException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        } catch (SAXNotSupportedException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        } finally {
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}