/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.alias.pool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

import blanco.ig.generator.GeneratorSetting;

/**
 * @author Yasuo Nakanishi
 */
public class AliasReportWriter {
    private GeneratorSetting _setting = null;

    public AliasReportWriter(GeneratorSetting setting) {
        _setting = setting;
    }

    private String getFilePath() {
        return _setting.getWorkDirectory() + "/AliasReport.xml";
    }

    public void write(AliasPool aliasPool) throws IOException {

        File f = new File(getFilePath());
        OutputStream os = null;
        PrintStream ps = null;
        Iterator i = null;
        try {
            if (!checkWorkDirectory()) {
                createWorkDirectory();
            }

            os = new FileOutputStream(f);
            ps = new PrintStream(os, true, "UTF-8");

            ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ps.println();

            ps.println("<AliasReport>");
            i = aliasPool.getNotMatchedAliasIterator();
            Alias a = null;
            StringBuffer sb = null;
            ps.println("  <NotMatched>");
            while (i.hasNext()) {
                a = (Alias) i.next();
                if (!a.isMatched()) {
                    sb = new StringBuffer();
                    sb.append("    <Alias name=\"");
                    sb.append(a.getName());
                    sb.append("\" alias=\"");
                    sb.append(a.getAlias());
                    sb.append("\" />");
                    ps.println(sb.toString());
                }
            }
            ps.println("  </NotMatched>");
            ps.println("  <NotFinded>");
            i = aliasPool.getNotFindedNameIterator();
            while (i.hasNext()) {
                sb = new StringBuffer();
                sb.append("    <Alias name=\"");
                sb.append((String) i.next());
                sb.append("\" alias=\"");
                sb.append("\" />");
                ps.println(sb.toString());
            }
            ps.println("  </NotFinded>");
            ps.println("</AliasReport>");
        } finally {
            if (ps != null) {
                ps.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean checkWorkDirectory() {
        File f = new File(_setting.getWorkDirectory());
        return f.exists() && f.isDirectory();
    }

    private void createWorkDirectory() throws IOException {
        File f = new File(_setting.getWorkDirectory());
        if (!f.mkdirs()) {
            String message = "ƃfBNg̍쐬Ɏs܂BPath:";
            message += f.getAbsolutePath();
            throw new IOException(message);
        }
    }
}