/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.collector;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.BlancoDbDefinition;
import blanco.db.exception.BlancoDbException;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbCollector {
    private BlancoDbSetting _setting = null;

    private BlancoDbMetadata _metadata = null;

    private BlancoDbDefinition _definition = null;

    private DatabaseService _databaseService = null;

    public BlancoDbCollector(BlancoDbSetting setting) {
        _setting = setting;
    }

    /**
     * TableGatewayȊOW܂B
     * 
     * @param metadata
     * @param conn
     * @return
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     */
    public BlancoDbDefinition collect(BlancoDbMetadata metadata,
            BlancoDbDatabaseConnection conn) throws SQLException, SAXException,
            IOException, ParserConfigurationException, BlancoDbException {
        _metadata = metadata;
        _definition = new BlancoDbDefinition(_metadata.getName());

        _databaseService = new DatabaseService(_setting.getJdbc(), conn);

        IteratorCollector _iteratorCollector = new IteratorCollector(_setting,
                _databaseService);
        List iteratorList = _iteratorCollector.collect(_metadata);
        _definition.setIteratorList(iteratorList);

        InvokerCollector invokerCollector = new InvokerCollector();
        List invokerList = invokerCollector.collect(_setting, _metadata);
        _definition.setInvokerList(invokerList);

        return _definition;
    }

    /**
     * TableGatewaŷ݂W܂B
     * 
     * @param metadata
     * @param conn
     * @return
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     */
    public BlancoDbDefinition collectTableGateway(BlancoDbMetadata metadata,
            BlancoDbDatabaseConnection conn) throws SQLException, SAXException,
            IOException, ParserConfigurationException, BlancoDbException {
        _metadata = metadata;
        _definition = new BlancoDbDefinition(_metadata.getName());

        _databaseService = new DatabaseService(_setting.getJdbc(), conn);

        GatewayCollector gatewayCollector = new GatewayCollector(
                _databaseService);
        List list = gatewayCollector.collect(_metadata);
        _definition.setGatewayList(list);

        return _definition;
    }
}